#ifndef UDPCONFIG_H
#define UDPCONFIG_H
/*******************************************************************************
*  (c) synertronixx GmbH
*  Lange Laube Str. 22
*  30159 Hannover
*  Tel. : 0511 / 262 999  0
*  Fax. : 0511 / 262 999 29
*  Web  : www.synertronixx.de
*  eMail: devilanapp@synertronixx.de
* ----------------------------
* Project       : DeviLAN App RC server  
* Name          : udpconfig.c
* Version       : see variable "appl_version_info"
* Date          : 28.09.2012
* Author        : DeviLAN app team
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* *****************************************************************************/


/*------------------------------------------------------------------------------
 * defines
 *-----------------------------------------------------------------------------*/
/* socket settings */
#define UDP_MAXLEN                  128

#define DHCP_OFF                    0
#define DHCP_ON                     1

#define UDP_INDENT_DATAGRAM_LEN     62

#define UDP_COMMAND_INDENTIFY_ALL   0x0001
// #define UDP_COMMAND_INDENTIFY       0x0002
#define UDP_COMMAND_INDENTIFICATION 0x0003
// #define UDP_COMMAND_CONFIGURATION   0x0004
// #define UDP_COMMAND_REBOOT          0x0005

/* default udp- and inet-data values */
#define DEFAULT_INET_DHCP           DHCP_OFF
#define DEFAULT_UDP_MODULNAME       "DeviLAN App RC server"
#define DEFAULT_UDP_SERIAL          0
#define DEFAULT_UDP_TCPPORT         3333
#define DEFAULT_UDP_UDPPORT         8002

/* error defs */
#define ERR_SEARCHSTRING_NOTFOUND   -1
#define ERR_FILE_NOTFOUND           -2
#define ERR_INTERFACE_NOTFOUND      -3
#define ERR_INETDATA_NOTFOUND       -4
#define ERR_UDPDATA_NOTFOUND        -5
#define ERR_INVALIDCOMMAND          -6
#define ERR_NOTMYDATAGRAM           -7


/*------------------------------------------------------------------------------
 * structures
 *-----------------------------------------------------------------------------*/
struct inet {
	char mac_nr[6];
	uint32_t address;
	//struct in_addr address;
	uint32_t broadcast;
	uint32_t netmask;
	uint32_t gateway;
	char dhcp;
};

struct udp {
	char modul_name[33];
	uint32_t     serial;
	unsigned int tcp_ip_port;
	unsigned int udp_port;
	unsigned int udp_datagram_len;
	unsigned int udp_command;
};

struct udp_data {
	struct inet inet;
	struct udp udp;
};



// creates a new socket
int UDPCreateServerSocket (uint16_t udp_broadcast_port);

// gets the udp-data stored in /etc/network/interfaces
int UDPGetConfigData (struct udp_data *new_udp_data);

// creates a new message to send back after broadcast or indent-cmd
void UDPCreateIndentMsg (struct udp_data new_udp_data, char *message);

//description: interprets the command in datagram-message
void UDPCommandInterpreter (struct udp_data *new_udp_data, char *message);

// description: handles the new data when received
int UDPReceiveHandler (int sock, struct udp_data *my_udp_data);

// cuts out data between the search-string and end-of-line from
int string_cut (char *source, char *data, char *string);

// description: writes mac-address to a pointer to an udp-data structure
void GetMAC (int sock, struct udp_data *my_udp_data);

// init UDP communication for identification message
int UDPInit(void);

// process incomming UDP messages
void UDPProcessCommands(void);

// close UDP listener
void UDPClose(void);


#endif

// end of file

