/*******************************************************************************
*  (c) synertronixx GmbH
*  Lange Laube Str. 22
*  30159 Hannover
*  Tel. : 0511 / 262 999  0
*  Fax. : 0511 / 262 999 29
*  Web  : www.synertronixx.de
*  eMail: devilanapp@synertronixx.de
* ----------------------------
* Project       : DeviLAN App RC server  
* Name          : terminal.c
* Version       : see variable "appl_version_info"
* Date          : 28.09.2012
* Author        : DeviLAN app team
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* *****************************************************************************/

// System header
#include <termios.h>
#include <unistd.h>
#include <stdio.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>

// Project
#include "terminal.h"


// globals
struct termios saved_attributes; // Used to remember original terminal attributes

// externals from devilanapprcserver.c
extern char* appl_name;		    // Application name for debug messages
extern char* appl_version_info;	// Application Version
extern int  running;

// externals from rcserver.c
extern int debug_traffic;         // marker for debug output


/******************************************************************************
Function:     TerminationHandler
Description:  handler for program termination called by kill, Crtl-c, etc.
Parameter:    
Return:       none
Date:         28.09.2012
Changes:
******************************************************************************/
void
TerminationHandler (int signum)   
{
	if (signum!=13)
		printf("%s: Termination Handler Signal-Nr. %d\n", appl_name, signum);

	if ( signum!=SIGPIPE )
		running=0;

	signal (signum, TerminationHandler);
}
/******************************************************************************
Function:     InsertTerminationHandler
Description:  insert termination handler
Parameter:    none
Return:       none
Date:         28.09.2012
Changes:
******************************************************************************/
void
InsertTerminationHandler(void)
{
	signal(SIGINT, TerminationHandler); // Ctrl-C
	///signal(SIGSTOP,TerminationHandler); // interrupt
	signal(SIGHUP, TerminationHandler); // kill -HUP
	signal(SIGTERM,TerminationHandler); // kill
	signal(SIGKILL,TerminationHandler); // kill
	signal(SIGQUIT,TerminationHandler); // kill
	signal(SIGPIPE,TerminationHandler); // Pipe broken
	///signal(SIGCONT,TerminationHandler); // continue
}

/******************************************************************************
Function:     TerminalResetInputMode  
Description:  set/restore the original terminal settings
Parameter:    none
Return:       none
Date:         28.09.2012
Changes:
******************************************************************************/
void
TerminalResetInputMode(void)
{
	tcsetattr (STDIN_FILENO, TCSANOW, &saved_attributes);
}


/******************************************************************************
Function:     TerminalSetInputMode  
Description:  set new terminal settings
Parameter:    none
Return:       none
Date:         28.09.2012
Changes:
******************************************************************************/
void
TerminalSetInputMode (void)
{
	struct termios tattr;
	int retval;

	// Make sure stdin is a terminal.
	if (!isatty (STDIN_FILENO))
	{
		fprintf (stderr, "Not a terminal!\n");
		printf ("%s: Not a terminal!\n", appl_name);
	} else
	{
		printf("%s: Setting keyboard as command interface\n", appl_name);

		// Save the terminal attributes so we can restore them later.
		retval = tcgetattr (STDIN_FILENO, &saved_attributes);
		atexit (TerminalResetInputMode);	 // set exit Function

		// Set the funny terminal modes.
		retval = tcgetattr (STDIN_FILENO, &tattr);
		tattr.c_lflag &= ~(ICANON|ECHO); // Clear ICANON and ECHO.
		//tattr.c_cc[VMIN] = 1;
		tattr.c_cc[VMIN] = 0;
		tattr.c_cc[VTIME] = 0;
		retval = tcsetattr (STDIN_FILENO, TCSAFLUSH, &tattr);
	}
}

 
/******************************************************************************
Function:     TerminalPrintKeyboardInfo 
Description:  print information about keyboard funtion to standard ouput
Parameter:    none
Return:       none
Date:         28.09.2012
Changes:
******************************************************************************/
void
TerminalPrintKeyboardInfo(void)
{
	printf("\n\n%s: Keyboard Information\n", appl_name);
	printf("%s: %s\n", appl_name, appl_version_info);
	printf("%s: Press\n", appl_name);
	printf("%s: 'q' for quit\n",  appl_name);
    printf("%s: 'd' to toggle debug output for socket traffic (%d)\n\n",  appl_name, debug_traffic);
}


/******************************************************************************
Function:     TerminalHandleKeyboardInputs 
Description:  handle keyboard inputs
Parameter:    none
Return:       none
Date:         09.12.2012
Changes:
******************************************************************************/
void
TerminalHandleKeyboardInputs(void)
{
  int  result=0;	 // result of read function
  char key;			// key pressed

  // any keyboard inputs
  result = read (STDIN_FILENO, &key, 1);
  if (result>0)
  { // got keyboard input
    if(key == 'q')
      running = 0;  // quit program
    if(key == 'd')
    {
      if(debug_traffic)
        debug_traffic=0;
      else
        debug_traffic=1;
    }
    TerminalPrintKeyboardInfo();
  }
}


// end of file
