#ifndef _SOCKETSERVER_H__
#define _SOCKETSERVER_H__
/*******************************************************************************
*  (c) synertronixx GmbH
*  Lange Laube Str. 22
*  30159 Hannover
*  Tel. : 0511 / 262 999  0
*  Fax. : 0511 / 262 999 29
*  Web  : www.synertronixx.de
*  eMail: devilanapp@synertronixx.de
* ----------------------------
* Project       : DeviLAN App RC server  
* Name          : socketserver.h
* Version       : see variable "appl_version_info"
* Date          : 28.09.2012
* Author        : DeviLAN app team
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* *****************************************************************************/

// System Header
#include <sys/socket.h>
#include <netinet/in.h>


#define BUF 4096
#define DEFAULT_TCPPORT		3333


// creates an new server socket
int ServerSocketInit(int* sock, struct sockaddr_in* address, socklen_t* addr_len);

// after the first connection, sends the modultype
int ServerSendFirstMsg(int* sock);

// send a string to the socket
int ServerSendMsg(int* socket, char* buffer);

// rreads out socket data until CR is received and calls data processing function
int ServerGetMsg(int* socket, char* buffer);

// checks with select, if there a new connection 
int ServerLookForConnections(int* server_socket, int* client_socket, fd_set* read_fd_set);


#endif

// end of file
