#ifndef _RCSERVER_H__
#define _RCSERVER_H__
/*******************************************************************************
*  (c) synertronixx GmbH
*  Lange Laube Str. 22
*  30159 Hannover
*  Tel. : 0511 / 262 999  0
*  Fax. : 0511 / 262 999 29
*  Web  : www.synertronixx.de
*  eMail: devilanapp@synertronixx.de
* ----------------------------
* Project       : DeviLAN App RC server  
* Name          : rcserver.h
* Version       : see variable "appl_version_info"
* Date          : 15.01.2013
* Author        : DeviLAN app team
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* *****************************************************************************/


// Display orientation modes
enum DISPLAY_MODES
{
    DISPLAY_IPHONE_PORTRAIT,
    DISPLAY_IPHONE_LANDSCAPE,
    DISPLAY_IPAD_PORTRAIT,
    DISPLAY_IPAD_LANDSCAPE
};



// Remote control and visualization scenes
enum RCSCENES
{
    SCENE_MAIN_IPHONE,
    SCENE_MAIN_IPAD,
    
    SCENE_OVERVIEW,
    SCEND_MIXED,
    SCENE_MIXED_UPDATE,
    
    SCENE_MENU_SUBMENU,
    SCENE_MENU_SUBMENU_LIVING,
    SCENE_MENU_SUBMENU_BATH,
    SCENE_MENU_SUBMENU_KITCHEN,
    SCENE_MENU_SUBMENU_GARAGE,

    SCENE_NEWSTICKER,
   
    SCENE_GRAPH_ANALOG_IPHONE,
    SCENE_GRAPH_ANALOG_IPAD,
    SCENE_GRAPH_DIGITAL,
    SCENE_GRAPH_PSEUDO_BAR_VERTICAL,
    SCENE_GRAPH_PSEUDO_BAR_HORIZONTAL,
    SCENE_GRAPH_SLIDER_CONTROLLED,

    SCENE_AUDIO,

    SCENE_DRAW_BASICS,
    SCENE_DRAW_BARGRAPH_PIECHART_IPHONE,
    SCENE_DRAW_BARGRAPH_PIECHART_IPAD,
    SCENE_DRAW_CURVES,

    SCENE_MAP_INTERACTION,
    SCENE_MAP_PICTURES

};


// init all variables for RC server
void RCServerInit(void);

// process incomming commands
void RCDataHandler(int* sock, char* buffer);

// Get main menu depending in hardware and orientation
int RCGetMainScene(void);

// get analog graph scene no. depending om hardware and orientation
int RCGetAnaloGraphScene(void);

// get pie chart scene no. depending om hardware and orientation
int RCGetChartScene(void);

// send commands to DeviLAN app
void RCNextStep(int* sock);

// change settings for new scene
void RCChangeScene(void);

// draw a bar graph and a pie chart
void RCDrawDemoChart(int* sock, float scale);

// draw a curve graph
void RCDrawDemoCurves(int* sock);


// send a string to TCP/IP socket
int SendStringToStream(int* sock, char* str);


#endif
// end of file

