/*******************************************************************************
*  (c) synertronixx GmbH
*  Lange Laube Str. 22
*  30159 Hannover
*  Tel. : 0511 / 262 999  0
*  Fax. : 0511 / 262 999 29
*  Web  : www.synertronixx.de
*  eMail: devilanapp@synertronixx.de
* ----------------------------
* Project       : DeviLAN App RC server  
* Name          : rcserver.c
* Version       : see variable "appl_version_info"
* Date          : 15.01.2013
* Author        : DeviLAN app team
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
******************************************************************************/

// System header
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>


// Project header
#include "rcserver.h"
#include "socketserver.h"
#include "terminal.h"

// --------------- RC  ---------------------
// Scenes
unsigned int counter_test; // counter for sending commands
int scene_nr;              // selected scene                                  
#define TEST_DATA_SCENE 24 // TEST_DATA_SCENE remote control scenes ...
#define TEST_DATA_SIZE 100 // ... with a max. of TEST_DATA_SIZE entries
char* test_data[TEST_DATA_SCENE][TEST_DATA_SIZE];  // buffer for all Remote controls/scenes
int timertime_remote_test; // default time for cyclic sending commands
int timertime;             // actual cycle time for sending commands
int debug_traffic=0;       // marker set for debug output (set to 1 to get print socket demo)



// just some help counter and variables for sending data to control elements
float graphTestCnt;
float graphTestCnt2;
int digital_color_on[8];
int bar_filled;
unsigned int ticker_cnt; 
int bargraphCnt;
int map_count=0;
float freq_scale=1;
int display_mode=DISPLAY_IPHONE_PORTRAIT;
int display_width=100;

// externals from devilanapprcserver.c
extern char* appl_name;		    // Application name for debug messages


/******************************************************************************
 Function:     RCServerInit
 Description:  init all variables for RC server
 Parameter:    none
 Return:       none
 Date:         15.01.2013
 Changes:
 ******************************************************************************/
void
RCServerInit(void)
{
    int i,j;
    
    // clear all scenes
    for(j=0; j<TEST_DATA_SCENE; j++)
    {
        for(i=0; i<TEST_DATA_SIZE; i++)
            test_data[j][i] = NULL;
    }
    
    // reset all counters
    counter_test  = 0;
    ticker_cnt    = 0;
    graphTestCnt  = 0;
    graphTestCnt2 = 0;
    bar_filled    = 1;
    bargraphCnt   = 0;
    
    
    //---------------------------------------------------------------------------
    // Scene: Main menu iPhone & iPod
    j=SCENE_MAIN_IPHONE;
    i=0;
    test_data[j][i++] = "rmt_clear";
    test_data[j][i++] = "rmt_header1_bb_cfg ;Main menu for iPhone & iPod";
    test_data[j][i++] = "rmt_text1_a1_cfg ;  Demo mode: App behaves like connected to a server controlling the GUI and reacts to your interaction. Please choose an example below. To return from example press button '<<Back to main menu'. Press 'Stop demo' at the bottom of this view to end demo.;2";

    test_data[j][i++] = "rmt_button1_a1_cfg ;1. All control elements";
    test_data[j][i++] = "rmt_button1_a2_cfg ;2. Mixed control elements";
    test_data[j][i++] = "rmt_button1_a3_cfg ;3. Some control elements with update";
    test_data[j][i++] = "rmt_button1_a4_cfg ;4. Control Menu with Sub-Menus";
    test_data[j][i++] = "rmt_button1_a5_cfg ;5. Newsticker";
    
    test_data[j][i++] = "rmt_button1_a6_cfg ;6. Graph: Analog with data generator";
    test_data[j][i++] = "rmt_button1_a7_cfg ;7. Graph: Digital with data generator";
    test_data[j][i++] = "rmt_button1_a8_cfg ;8. Graph: Pseudo bar graph vertical";
    test_data[j][i++] = "rmt_button1_a9_cfg ;9. Graph: Pseudo bar graph horizontal";
    test_data[j][i++] = "rmt_button1_b0_cfg ;10. Graph: Graph controlled by slider";
    test_data[j][i++] = "rmt_button1_b1_cfg ;11. Audio elements";
    test_data[j][i++] = "rmt_button1_b2_cfg ;12. Draw element: Basics";
    test_data[j][i++] = "rmt_button1_b3_cfg ;13. Draw element: Bar graph & Pie chart";
    test_data[j][i++] = "rmt_button1_b4_cfg ;14. Draw element: Some curves";
    test_data[j][i++] = "rmt_button1_b5_cfg ;15. Map: with interaction";
    test_data[j][i++] = "rmt_button1_b6_cfg ;16. Map: Hannover photo show";
    
    test_data[j][i++] = "rmt_header1_99_cfg ;Last entry of RC";
    
    //---------------------------------------------------------------------------
    // Scene: Main menu iPad
    j= SCENE_MAIN_IPAD;
    i=0;
    test_data[j][i++] = "rmt_clear";
    test_data[j][i++] = "rmt_header1_bb_cfg ;Main menu for iPad";
    test_data[j][i++] = "rmt_text1_a1_cfg ;  Demo mode: App behaves like connected to a server controlling the GUI and reacts to your interaction. Please choose an example below. To return from example press button '<<Back to main menu'. Press 'Stop demo' at the bottom of this view to end demo.;2";
    
    test_data[j][i++] = "rmt_button1_a1_cfg ;1. All control elements";
   
    test_data[j][i++] = "rmt_button2_p0_cfg ;2. Mixed control elements;3. Some control elements with update";
    test_data[j][i++] = "rmt_button2_p1_cfg ;4. Control Menu with Sub-Menus;5. Newsticker";
    test_data[j][i++] = "rmt_button2_p2_cfg ;6. Graph: Analog with data generator;7. Graph: Digital with data generator";
    test_data[j][i++] = "rmt_button2_p3_cfg ;8. Graph: Pseudo bar graph vertical;9. Graph: Pseudo bar graph horizontal";
    test_data[j][i++] = "rmt_button2_p4_cfg ;10. Graph: Graph controlled by slider;11. Audio elements";
    test_data[j][i++] = "rmt_button2_p5_cfg ;12. Draw element: Basics;13. Draw element: Bar graph & Pie chart";
    test_data[j][i++] = "rmt_button2_p6_cfg ;14. Draw element: Some curves;";
    test_data[j][i++] = "rmt_button2_p7_cfg ;15. Map: with interaction;16. Map: Hannover photo show";
    test_data[j][i++] = "rmt_header1_99_cfg ;Last entry of RC";
    
    
    //---------------------------------------------------------------------------
    // Scene: All elements
    j=SCENE_OVERVIEW;
    i=0;
    test_data[j][i++] = "rmt_clear";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    test_data[j][i++] = "rmt_header1_aa_cfg ;All GUI Elements: Header type 1";
    
    //------------------------
    // Control elements
    test_data[j][i++] = "rmt_header1_bb_cfg ;---- Control elements ----";
    test_data[j][i++] = "rmt_pick1_a1_cfg ;Picker description:;1;Value 1;Value 2;Value 3;Value 4;Value 5;Value 6";
    test_data[j][i++] = "rmt_radio1_a1_cfg ;Description for segment/radio button element:; 0;Value 1;Value 2;Value 3;Value n-1;Value n";
    test_data[j][i++] = "rmt_slider1_aa_cfg ;Slider type 1 description:; 0; 100; 25; %5.2fHz; 0.1";
    test_data[j][i++] = "rmt_switch1_aa_cfg ;Switch type 1 description:; 1";
    test_data[j][i++] = "rmt_switch3_aa_cfg ;Left; 1;Middle;1;Right;1";
    test_data[j][i++] = "rmt_button1_aa_cfg ;Middle Button type 1";
    test_data[j][i++] = "rmt_button2_aa_cfg ;Left Button type 2;Right Button type 2";
    test_data[j][i++] = "rmt_button3_aa_cfg ;Left Button;Type 3;Right Button";
    test_data[j][i++] = "rmt_edit1_aa_cfg ;Edit field type 1 description:;Enter text here";
    
    //------------------------
    // Visualization elements
    test_data[j][i++] = "rmt_header1_cc_cfg ;---- Visualization elements ----";
    test_data[j][i++] = "rmt_graph1_aa_cfg ;Description text for graph:;4;170; 50; %.1f; -3.5; 3.5; 7";
    test_data[j][i++] = "rmt_progress1_aa_cfg ;Progress type 1 description:; 0; 100; 25; %5.2fHz; 1.0";
    test_data[j][i++] = "rmt_text1_aa_cfg ; Scroll text with speed 2, this could be a news ticker, your actual stock report, .....;2";
    test_data[j][i++] = "rmt_audio1_aa_cfg ;Title: Audio_01.m4a;http://www.synertronixx.de/audio/audio_01.m4a; 1";
    
    // draw element
    test_data[j][i++] = "rmt_draw1_a1_cfg ;Description text for draw element:;150",
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0.8;0.8;0.8;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;r;0;0;1000;1000;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;c;1;1;0;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;a;140;60;50;0.0;6.3;0;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0;0;0;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;a;120;40;5;0.0;6.3;0;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;a;160;40;5;0.0;6.3;0;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;a;140;60;30;0.0;3.14;0;0";
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0;1;0;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;t;20;120;20;l;Start your day with a smile!";

    // map element
    test_data[j][i++] = "rmt_map1_aa_cfg ;Map description:; 200; 52.3768; 9.7283;1000; 0;1";
    test_data[j][i++] = "rmt_map1_aa_data ;52.3768; 9.7283;Homepage synertronixx;This is our homepage!;http://www.synertronixx.de";
    test_data[j][i++] = "rmt_map1_aa_data ;52.3768; 9.7285;Logo synertronixx;This in a our logo!;http://www.synertronixx.de/images/synertronixx_sphere.jpg";
    test_data[j][i++] = "rmt_map1_aa_data ;52.3768; 9.7287;SCB9324;This is a our socket computer SCB9324;http://www.synertronixx.de/images/scb9324_small_1.jpg";
    
     // Webview
    test_data[j][i++] = "rmt_header1_w1_cfg ;Webview 'www.synertronixx.de'",
    test_data[j][i++] = "rmt_web1_aa_cfg ;http://www.synertronixx.de;250",
    
    
    // test_data[j][i++] = "rmt_header1_bb_cfg ;";
    
    //---------------------------------------------------------------------------
    // Scene: Mixed examples
    j= SCEND_MIXED;
    i=0;
    test_data[j][i++] = "rmt_clear";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    test_data[j][i++] = "rmt_header1_01_cfg ;Slider examples";
    test_data[j][i++] = "rmt_slider1_00_cfg ;Slider 1 (simple output):; 5; 50; 25";
    test_data[j][i++] = "rmt_slider1_01_cfg ;Slider 2 (formated output):; 0; 200; 100;%5.2fm;0.1";
    test_data[j][i++] = "rmt_slider1_02_cfg ;Slider 3 (no output):; 0; 100; 25;;";
    
    test_data[j][i++] = "rmt_header1_02_cfg ;Progess examples";
    test_data[j][i++] = "rmt_progress1_01_cfg ;Progress type 1 description:; 0; 100; 10";
    test_data[j][i++] = "rmt_progress1_02_cfg ;Progress type 1 description:; 0; 100; 25; %5.2fHz; 1.0";
    
    test_data[j][i++] = "rmt_header1_03_cfg ;Switch examples";
    test_data[j][i++] = "rmt_switch1_01_cfg ;Switch no. 1; 0";
    test_data[j][i++] = "rmt_switch1_02_cfg ;Switch no. 2; 1";
    test_data[j][i++] = "rmt_switch3_01_cfg ;Switch no. 3; 1;Switch no. 4; 0;Switch no. 5; 1";
    test_data[j][i++] = "rmt_switch3_02_cfg ;Switch no. 6; 0;;0;Switch no. 7; 1";
    test_data[j][i++] = "rmt_switch3_03_cfg ;;0;Switch no. 8;1;;1";
    
    test_data[j][i++] = "rmt_header1_04_cfg ;Button examples";
    test_data[j][i++] = "rmt_button3_a1_cfg ;Left;Middle;Right";
    test_data[j][i++] = "rmt_button3_b1_cfg ;Left;;";
    test_data[j][i++] = "rmt_button3_c1_cfg ;;Middle;";
    test_data[j][i++] = "rmt_button3_d1_cfg ;;;Right";
    test_data[j][i++] = "rmt_button3_e1_cfg ;Left;;Right";
    test_data[j][i++] = "rmt_button2_f1_cfg ;Left Button;Right Button";
    test_data[j][i++] = "rmt_button1_f1_cfg ;One large button";
    
    
    test_data[j][i++] = "rmt_header1_05_cfg ;Edit examples";
    test_data[j][i++] = "rmt_edit1_01_cfg ;Enter text here:;....text to send";
    test_data[j][i++] = "rmt_edit1_02_cfg ;;Hello world";
    
    test_data[j][i++] = "rmt_header1_06_cfg ;Scroll text examples:";
    test_data[j][i++] = "rmt_text1_01_cfg ; Static text (speed 0);0";
    test_data[j][i++] = "rmt_text1_02_cfg ; News Ticker with speed 1: This is message no. 1 .... This is message no. 2 ... This is message no. 3 ...;1";
    test_data[j][i++] = "rmt_text1_03_cfg ; News Ticker with speed 2: This is message no. 1 .... This is message no. 2 ... This is message no. 3 ...;2";
    test_data[j][i++] = "rmt_text1_04_cfg ; News Ticker with speed 3: This is message no. 1 .... This is message no. 2 ... This is message no. 3 ...;3";
        
    
    //---------------------------------------------------------------------------
    // Scene: Mixed with animation
    j=SCENE_MIXED_UPDATE;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_header1_05_cfg ;Mixed examples";
    test_data[j][i++] = "rmt_slider1_AA_cfg ;Temperature bathroom; 5; 35; 25";
    test_data[j][i++] = "rmt_progress1_AA_cfg ;Frequency:; 0; 100; 25; %5.2fHz; 0.5";
    test_data[j][i++] = "rmt_switch1_10_cfg ;Light intern; 1";
    test_data[j][i++] = "rmt_button3_10_cfg ;Start;Stop;Pause";
    test_data[j][i++] = "rmt_edit1_11_cfg ;Enter text here:;Text to send 1";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
    
    //---------------------------------------------------------------------------
    // Scene: Button with submenu
    j = SCENE_MENU_SUBMENU;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_header1_a1_cfg ;Heating and light control";
    test_data[j][i++] = "rmt_header1_a2_cfg ;Press a button to get sub menu";
    test_data[j][i++] = "rmt_button2_a1_cfg ;Living room;Bath room";
    test_data[j][i++] = "rmt_button2_a2_cfg ;Kitchen;Garage";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
    //---------------------------------------------------------------------------
    // Scene: Submenu living room
    j = SCENE_MENU_SUBMENU_LIVING;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_header1_a1_cfg ;Heating and light control";
    test_data[j][i++] = "rmt_header1_b1_cfg ;Living room";
    test_data[j][i++] = "rmt_slider1_b1_cfg ;Temperature living room:; 5; 35; 19;%5.1fGrad;1";
    test_data[j][i++] = "rmt_switch1_b1_cfg ;Light 1:; 1";
    test_data[j][i++] = "rmt_switch1_b2_cfg ;Light 2:; 0";
    test_data[j][i++] = "rmt_button3_z2_cfg ;<< Back;;";
    
    
    //---------------------------------------------------------------------------
    // Scene: Submenu bathroom
    j=SCENE_MENU_SUBMENU_BATH;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_header1_a1_cfg ;Heating and light control";
    test_data[j][i++] = "rmt_header1_c1_cfg ;Bath room";
    test_data[j][i++] = "rmt_slider1_c1_cfg ;Temperature bath room:; 5; 35; 21;%5.1fGrad;1";
    test_data[j][i++] = "rmt_switch1_c1_cfg ;Light 1:; 1";
    test_data[j][i++] = "rmt_button3_z2_cfg ;<< Back;;";
    
    //---------------------------------------------------------------------------
    // Scene: Kitchen
    j=SCENE_MENU_SUBMENU_KITCHEN;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_header1_a1_cfg ;Heating and light control";
    test_data[j][i++] = "rmt_header1_d1_cfg ;Kitchen";
    test_data[j][i++] = "rmt_slider1_d1_cfg ;Temperature kitchen:; 5; 35; 21;%5.1fGrad;1";
    test_data[j][i++] = "rmt_switch1_d1_cfg ;Light 1:; 1";
    test_data[j][i++] = "rmt_button3_z2_cfg ;<< Back;;";
    
    //---------------------------------------------------------------------------
    // Scene: Garage
    j=SCENE_MENU_SUBMENU_GARAGE;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_header1_a1_cfg ;Door and light control";
    test_data[j][i++] = "rmt_header1_e1_cfg ;Garage";
    test_data[j][i++] = "rmt_switch1_e1_cfg ;Light 1:; 0";
    test_data[j][i++] = "rmt_switch1_e2_cfg ;Door :; 0";
    test_data[j][i++] = "rmt_button3_z2_cfg ;<< Back;;";
    
    
    //---------------------------------------------------------------------------
    // Scene: Newticker
    j=SCENE_NEWSTICKER;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_header1_f1_cfg ;Just a text (speed 0)";
    test_data[j][i++] = "rmt_text1_f1_cfg ;  Static text no scrolling;0";
    test_data[j][i++] = "rmt_header1_f2_cfg ;News ticker (speed 1)";
    test_data[j][i++] = "rmt_text1_f2_cfg ; This is message no. 1 .... This is message no. 2 ... This is message no. 3 ...;1";
    test_data[j][i++] = "rmt_header1_f3_cfg ;Stock ticker (speed 2)";
    test_data[j][i++] = "rmt_text1_f3_cfg ; Company A USD 100.00 (+1), Company B USD 200.00 (+1), Company C USD 300.00 (+1) ...;2";
    test_data[j][i++] = "rmt_header1_f4_cfg ;Just a fast scrolling text (speed 3)";
    test_data[j][i++] = "rmt_text1_f4_cfg ;This is a fast scrolling text with speed 3;3";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
   
    
    //---------------------------------------------------------------------------
    // Scene: Analog Graph with animation iPhone
    j=SCENE_GRAPH_ANALOG_IPHONE;
    i=0;
    test_data[j][i++] = "rmt_clear";

    test_data[j][i++] = "rmt_header1_05_cfg ;Graph examples";
    test_data[j][i++] = "rmt_graph1_b1_cfg ;Red=sin(x), Green=cos(x), Blue=tan(x), Yellow=4*sin(x)*cos(x/10):;5;112; 30; %.1f; -3.5; 3.5; 7";
    test_data[j][i++] = "rmt_graph1_b2_cfg ;Description text for graph (scroll right):;4;112; 50; %.1f; -55.0; 95.0; 5";
    test_data[j][i++] = "rmt_graph1_b3_cfg ;Description text for graph (scroll left):;4;112; 50; %.1f; -55.0; 95.0; 5; 1";
    test_data[j][i++] = "rmt_radio1_b1_cfg ;Frequency:;3;0.1 Hz;0.2 Hz; 0.5 Hz;1 Hz;2 Hz";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
    //---------------------------------------------------------------------------
    // Scene: Analog Graph with animation iPad
    j=SCENE_GRAPH_ANALOG_IPAD;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_header1_05_cfg ;Graph examples";
    test_data[j][i++] = "rmt_graph1_b1_cfg ;Red=sin(x), Green=cos(x), Blue=tan(x), Yellow=4*sin(x)*cos(x/10):;5;224; 30; %.1f; -3.5; 3.5; 7";
    test_data[j][i++] = "rmt_graph1_b2_cfg ;Description text for graph (scroll right):;4;112; 50; %.1f; -55.0; 95.0; 5";
    test_data[j][i++] = "rmt_graph1_b3_cfg ;Description text for graph (scroll left):;4;112; 50; %.1f; -55.0; 95.0; 5; 1";
    test_data[j][i++] = "rmt_radio1_b1_cfg ;Frequency:;3;0.1 Hz;0.2 Hz; 0.5 Hz;1 Hz;2 Hz";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";

    //---------------------------------------------------------------------------
    // Scene: Digital Graph with animation
    j=SCENE_GRAPH_DIGITAL;
    i=0;
    test_data[j][i++] = "rmt_clear";
    test_data[j][i++] = "rmt_graph1_b3_cfg ;Graph example with 'digital' values:;8;140; 35; %.1f; -0.5; 8.5; 9";
    test_data[j][i++] = "rmt_switch3_a1_cfg ;Red; 1;Green;1;Blue;1";
    test_data[j][i++] = "rmt_switch3_a2_cfg ;Yellow; 1;Pink;1;Turquoise;1";
    test_data[j][i++] = "rmt_switch3_a3_cfg ;Black; 1;White;1;;1";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
    //---------------------------------------------------------------------------
    // Scene: Audio
    j= SCENE_AUDIO;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_header1_05_cfg ;Audio examples";
    test_data[j][i++] = "rmt_audio1_h0_cfg ;Title: audio_01.m4a (unloaded);http://www.synertronixx.de/audio/audio_01.m4a; 0",
    test_data[j][i++] = "rmt_audio1_h1_cfg ;Title: audio_01.m4a (loaded));http://www.synertronixx.de/audio/audio_01.mp4a; 1",
    test_data[j][i++] = "rmt_audio1_h2_cfg ;Title: audio_01.m4a (load&play);http://www.synertronixx.de/audio/audio_01.m4a; 2",
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
    //---------------------------------------------------------------------------
    // Scene: Bar Graph
    j=SCENE_GRAPH_PSEUDO_BAR_VERTICAL;
    i=0;
    test_data[j][i++] = "rmt_clear";

    test_data[j][i++] = "rmt_graph1_b4_cfg ;Pseudo bar graph example with filled bars:;8;220; 35; %.1f; -5.; 85.0; 9";
    test_data[j][i++] = "rmt_switch1_b4_cfg ;Draw filled bars:; 1";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
   
    //---------------------------------------------------------------------------
    // Scene: Graph + Slider
    j=SCENE_GRAPH_SLIDER_CONTROLLED;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_graph1_b5_cfg ;Graph controlled by slider:;1;220; 35; %.1f; -5.; 85.0; 9";
    test_data[j][i++] = "rmt_slider1_b5_cfg ;Move slider:; 0; 80; 19;%.0f;1";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
    
    //---------------------------------------------------------------------------
    // Scene: Bar Graph horizontal
    j=SCENE_GRAPH_PSEUDO_BAR_HORIZONTAL;
    i=0;
    test_data[j][i++] = "rmt_clear";

    test_data[j][i++] = "rmt_graph1_b5_cfg ;Pseudo bar graph example with filled bars:;8;220; 35; %.1f; -5.; 85.0; 9";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
    
    //---------------------------------------------------------------------------
    // Scene: Draw element basics
    j=SCENE_DRAW_BASICS;
    i=0;
    test_data[j][i++] = "rmt_clear";
    
    test_data[j][i++] = "rmt_draw1_a1_cfg ;Basic objects for draw element:;300",
    // test_data[j][i++] = "rmt_button1_z2_cfg ;";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
    // clear
    test_data[j][i++] = "rmt_draw1_a1_data ;d";
    test_data[j][i++] = "rmt_draw1_a1_data ;u";
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0.8;0.8;0.8;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;r;0;0;1000;300;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0;0;0;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;r;2;2;316;296;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0.8;0.8;0.8;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;r;4;4;312;292;1";
    
    
    // rects
    test_data[j][i++] = "rmt_draw1_a1_data ;c;1;0.6;0.2;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;t;10;5;15;l;Rects:",

    test_data[j][i++] = "rmt_draw1_a1_data ;c;1;0;1;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;r;30;30;30;30;0";
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0;0.5;0.3;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;r;70;20;40;40;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0;0;1;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;r;30;80;60;10;1";
    
    // ellipse
    test_data[j][i++] = "rmt_draw1_a1_data ;c;1;0.6;0.2;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;t;10;100;15;l;Ellipses:",
    test_data[j][i++] = "rmt_draw1_a1_data ;c;1;0;0;0.8";
    test_data[j][i++] = "rmt_draw1_a1_data ;e;20;120;50;20;0";
    test_data[j][i++] = "rmt_draw1_a1_data ;e;20;150;80;50;1";
    
   
    // lines
    test_data[j][i++] = "rmt_draw1_a1_data ;c;1;0.6;0.2;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;t;110;90;15;l;Lines:",
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0;0;0;0.8";
    test_data[j][i++] = "rmt_draw1_a1_data ;l;100;110;150;150";
    test_data[j][i++] = "rmt_draw1_a1_data ;l;150;110;100;150";
    test_data[j][i++] = "rmt_draw1_a1_data ;l;120;200;120;290";
    
    
    // lines for arcs
    test_data[j][i++] = "rmt_draw1_a1_data ;l;200;60;200;230";
    test_data[j][i++] = "rmt_draw1_a1_data ;l;270;60;270;230";
    
    // texts
    test_data[j][i++] = "rmt_draw1_a1_data ;c;1;0.6;0.2;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;t;10;220;15;l;Texts:",
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0;0;0.5;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;t;120;230;15;l;Hello world left!";
    test_data[j][i++] = "rmt_draw1_a1_data ;t;120;250;15;c;Hello world center!";
    test_data[j][i++] = "rmt_draw1_a1_data ;t;120;270;15;r;Hello world right!";
    
    

    // Arcs & Circles
    test_data[j][i++] = "rmt_draw1_a1_data ;c;1;0.6;0.2;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;t;130;10;15;l;Arcs/Circles:",

    
    // circles
    test_data[j][i++] = "rmt_draw1_a1_data ;c;1;1;0;1";
    test_data[j][i++] = "rmt_draw1_a1_data ;a;240;20;15;0.0;6.3;0;0";
    test_data[j][i++] = "rmt_draw1_a1_data ;a;290;30;25;0.0;6.3;0;1";
    
    
    // Arcs
    test_data[j][i++] = "rmt_draw1_a1_data ;c;0.5;0;0.5;0.8",
    test_data[j][i++] = "rmt_draw1_a1_data ;a;270;60;40;0.0;2;0;0",
    test_data[j][i++] = "rmt_draw1_a1_data ;a;270;115;40;0.0;2;0;1",
    test_data[j][i++] = "rmt_draw1_a1_data ;a;270;160;40;0.0;2;0;2",
    test_data[j][i++] = "rmt_draw1_a1_data ;a;270;205;40;0.0;2;0;3",
    
    test_data[j][i++] = "rmt_draw1_a1_data ;c;1;0;0.5;0.8",
    test_data[j][i++] = "rmt_draw1_a1_data ;a;200;60;20;0.0;2;1;0",
    test_data[j][i++] = "rmt_draw1_a1_data ;a;200;105;20;0.0;2;1;1",
    test_data[j][i++] = "rmt_draw1_a1_data ;a;200;160;20;0.0;2;1;2",
    test_data[j][i++] = "rmt_draw1_a1_data ;a;200;205;20;0.0;2;1;3",
    
    
    //---------------------------------------------------------------------------
    // Scene: Bargraph and pie chart (Draw element)
    j=SCENE_DRAW_BARGRAPH_PIECHART_IPHONE;
    i=0;
    test_data[j][i++] = "rmt_clear";
    test_data[j][i++] = "rmt_draw1_a1_cfg ;Description text for draw element 1:;200",
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
    //---------------------------------------------------------------------------
    // Scene: Bargraph and pie chart (Draw element)
    j=SCENE_DRAW_BARGRAPH_PIECHART_IPAD;
    i=0;
    test_data[j][i++] = "rmt_clear";
    test_data[j][i++] = "rmt_draw1_a1_cfg ;Description text for draw element 1:;400",
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
    //---------------------------------------------------------------------------
    // Scene: some curves (Draw element)
    j=SCENE_DRAW_CURVES;
    i=0;
    test_data[j][i++] = "rmt_clear";

    test_data[j][i++] = "rmt_draw1_a1_cfg ;Description text for draw update:;200",
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";
    
     //---------------------------------------------------------------------------
    // Scene: interactive map with pins
    j=SCENE_MAP_INTERACTION;
    i=0;
    test_data[j][i++] = "rmt_clear";
    //test_data[j][i++] = "rmt_map1_a1_cfg ;Greetings from Hannover:; 280; 52.35500;9.73670;20000; 0;1";
    test_data[j][i++] = "rmt_map1_a1_cfg ;Move/zoom map to get new pins:; 200; 52.3768; 9.7283;1000;0;1";
    test_data[j][i++] = "rmt_text1_a1_cfg ;Latitude: 52.3768;0";
    test_data[j][i++] = "rmt_text1_a2_cfg ;Longitude: 9.7283;0";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";

    
    //---------------------------------------------------------------------------
    // Scene: map with pictures
    j=SCENE_MAP_PICTURES;
    i=0;
    test_data[j][i++] = "rmt_clear";
    test_data[j][i++] = "rmt_map1_bb_cfg ;Greetings from Hannover:; 280; 52.35500;9.73670;20000; 0;0";
    test_data[j][i++] = "rmt_button1_z1_cfg ;<< Back to main menu";


    test_data[j][i++] = "rmt_map1_bb_data ;52.37680;9.72830;Hannover Photo 1;Lange Laube 22: Home of synertronixx!;http://www.synertronixx.de/photos/hannover_lange_laube.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.37295;9.72958;Hannover Photo 2;Leinesuite;http://www.synertronixx.de/photos/hannover_leine_suite.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.37838;9.72414;Hannover Photo 3;Conti Campus;http://www.synertronixx.de/photos/hannover_conti_hochhaus.png";
    
    test_data[j][i++] = "rmt_map1_bb_data ;52.38585;9.71857;Hannover Photo 4;Township 'Nordstadt': Find the bicycle;http://www.synertronixx.de/photos/hannover_nordstadt.png";

    test_data[j][i++] = "rmt_map1_bb_data ;52.36711;9.72895;Hannover Photo 5;Waterloo place: Public viewing EM 2012;http://www.synertronixx.de/photos/hannover_waterloo_1.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.36614;9.72762;Hannover Photo 6;Waterloo place: ;http://www.synertronixx.de/photos/hannover_waterloo_2.png";


    test_data[j][i++] = "rmt_map1_bb_data ;52.37842;9.70950;Hannover Photo 7;Township 'Linden': view to powerplant;http://www.synertronixx.de/photos/hannover_linden_1.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.37842;9.70951;Hannover Photo 8;Township 'Linden': view to river 'Leine': ;http://www.synertronixx.de/photos/hannover_linden_2.png";

    
    test_data[j][i++] = "rmt_map1_bb_data ;52.38710;9.70264;Hannover Photo 9;Georgengarten: Garden festival;http://www.synertronixx.de/photos/hannover_georgengarten.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.37057;9.73732;Hannover Photo 10;City center: Roof garden 'Schoene Aussichten 360 Grad';http://www.synertronixx.de/photos/hannover_schoene_aussichten.png";
    
    
    test_data[j][i++] = "rmt_map1_bb_data ;52.36792;9.73732;Hannover Photo 11;New townhall;http://www.synertronixx.de/photos/hannover_neues_rathaus_1.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.36651;9.73725;Hannover Photo 12;New townhall back entrance;http://www.synertronixx.de/photos/hannover_neues_rathaus_2.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.36792;9.73733;Hannover Photo 13;New townhall;http://www.synertronixx.de/photos/hannover_neues_rathaus_3.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.36659;9.73663;Hannover Photo 14;New townhall view to 'Maschteich';http://www.synertronixx.de/photos/hannover_maschteich.png";
    
    test_data[j][i++] = "rmt_map1_bb_data ;52.35946;9.74151;Hannover Photo 15;Lake 'Maschsee' view to stadium;http://www.synertronixx.de/photos/hannover_maschsee_1.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.34756;9.75191;Hannover Photo 16;Lake 'Maschsee' view to 'Loewenbastion' (lakeside);http://www.synertronixx.de/photos/hannover_maschsee_2.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.34877;9.75033;Hannover Photo 17;Solar boat on lake 'Maschsee' ;http://www.synertronixx.de/photos/hannover_maschsee_3.png";
    
    test_data[j][i++] = "rmt_map1_bb_data ;52.34819;9.75120;Hannover Photo 18;Lake 'Maschsee' view to 'Loewenbastion';http://www.synertronixx.de/photos/hannover_maschsee_4.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.34880;9.75033;Hannover Photo 19;Lake 'Maschsee' view to lake;http://www.synertronixx.de/photos/hannover_maschsee_5.png";
    

    test_data[j][i++] = "rmt_map1_bb_data ;52.32470;9.80411;Hannover Photo 20;Hannover fair;http://www.synertronixx.de/photos/hannover_messe_1.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.32083;9.80512;Hannover Photo 21;Hannover fair;http://www.synertronixx.de/photos/hannover_messe_2.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.32318;9.80429;Hannover Photo 22;Hannover fair;http://www.synertronixx.de/photos/hannover_messe_3.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.32701;9.80898;Hannover Photo 23;Hannover fair;http://www.synertronixx.de/photos/hannover_messe_4.png";
    test_data[j][i++] = "rmt_map1_bb_data ;52.32144;9.81404;Hannover Photo 24;Hannover fair;http://www.synertronixx.de/photos/hannover_messe_5.png";

    
    // Timer times
    timertime_remote_test = 500;
    timertime = timertime_remote_test;
    
    // set default scene
    scene_nr = SCENE_MAIN_IPHONE;
    RCChangeScene();
    
}



/******************************************************************************
 Function:     DataHandler
 Description:  processes incomming commands
 Parameter:    sock:   ptr to socket descriptor
               buffer: ptr to buffer with received command
 Return:       always 0
 Date:         15.01.2013
 Changes:
 ******************************************************************************/
void
RCDataHandler(int* sock, char* buffer)
{
    char str_debug[1000]="R: ";
    char str[200]="0";
    char parameter_name[255]="";
    char parameter_value[255]="";
    int nr;
    float fx, fy, fz;
    float longitude, latitude, delta_longitude, delta_latitude;
    char device_str[20];
    int width, height;
    int display_mode_new;

    // Geo data, teslameter, compass
    float /* latitude, longitude,*/ altitude, accuracy_hor, accuracy_ver, speed;
    float tx, ty, tz;
    float compass;


    if (buffer[0]==0)
        return;       // empty string -> return
    
    // debug output
    if(debug_traffic)
        printf("%s: %s%s\n", appl_name, str_debug, buffer);
    
    // get parameter
    nr=sscanf(buffer, "%s", &parameter_name);
    if (nr != 1)
        return;  // empty string -> return
    
    
    // Get command and first parameter
    sscanf(buffer, "%s %s", &parameter_name, &parameter_value);
    
    //--------------------------------------------------------------------------
    // Hardware type and display orientation
    if (strcmp(parameter_name,"rmt_hardware")==0)
    {
        sscanf(buffer, "rmt_hardware %s %d %d", device_str, &width, &height);
        
        printf("%s: Hardware info: Type:%s  Width: %3d Height: %3d\n", appl_name, device_str, width, height);
        
        display_width = width;
        // Change the mode
        if( (strstr(device_str, "iPad")!= 0) || (strstr(device_str, "i386") != 0) )
        {
            if(width>height)
               display_mode_new = DISPLAY_IPAD_LANDSCAPE;
            else
               display_mode_new = DISPLAY_IPAD_PORTRAIT;
        }
        else
        {
            if(width>height)
                display_mode_new = DISPLAY_IPHONE_LANDSCAPE;
            else
                display_mode_new = DISPLAY_IPHONE_PORTRAIT;
        }
        
        // change main menu ?
        if( ((scene_nr == SCENE_MAIN_IPHONE) && ((display_mode_new == DISPLAY_IPAD_LANDSCAPE) || (display_mode_new == DISPLAY_IPAD_PORTRAIT)))   ||
            ((scene_nr == SCENE_MAIN_IPAD) && ((display_mode_new == DISPLAY_IPHONE_LANDSCAPE) || (display_mode_new == DISPLAY_IPHONE_PORTRAIT))) )  
        {
          printf("%s: Display mode changed to: %d\n", appl_name, display_mode_new);
          display_mode = display_mode_new;
                scene_nr = RCGetMainScene();
                RCChangeScene();
        }
        display_mode = display_mode_new;

        //printf("Display mode: %d\n", display_mode);
        return;
    }

    //--------------------------------------------------------------------------
    // Accelerometer data
    if (strcmp(parameter_name,"rmt_accf_data")==0)
    {
        sscanf(buffer, "rmt_accf_data %f %f %f", &fx, &fy, &fz);
        printf(str, "%s: Filtered data: X = %5.2f, Y = %5.2f, Z = %5.2f\n", appl_name, fx, fy, fz);
        return;
    }
    if (strcmp(parameter_name,"rmt_accr_data")==0)
    {
        float fx, fy, fz;
        sscanf(buffer, "rmt_accr_data %f %f %f", &fx, &fy, &fz);
        printf(str, "%s:Raw data: X = %5.2f, Y = %5.2f, Z = %5.2f\n", appl_name,fx, fy, fz);
        return;
    }

    //--------------------------------------------------------------------------
    // Geo data, teslameter, compass
   if (strcmp(parameter_name,"rmt_geodata")==0)
   {
     sscanf(buffer, "rmt_geodata %f %f %f %f %f %f %f %f %f %f", &latitude, &longitude, &altitude, &accuracy_hor,
                    &accuracy_ver, &speed, &tx, &ty, &tz, &compass);

     printf("%s:Geo data, teslameter, compass:\n Lat.:%.4f deg.  Long.: %.4f deg.  Alt.: %.1f m  Speed: %.1f m/s  AccH.: %.1f m  AccV.: %.1f m \n Tx: %.1f  Ty: %.1f  Tz: %.1f  Compass: %.1f\n\n",
             appl_name, latitude, longitude, altitude, speed, accuracy_hor, accuracy_ver, tx, ty, tz, compass);
 
     return;
   }
   



   //--------------------------------------------------------------------------
    // Submenues for button
    if ( (strcmp(parameter_name,"rmt_button2_a1_data_1")==0) && (parameter_value[0]=='1'))
    { // Living room control
        scene_nr = SCENE_MENU_SUBMENU_LIVING;
        RCChangeScene();
        return;
    }
    
    if ( (strcmp(parameter_name,"rmt_button2_a1_data_2")==0)  && (parameter_value[0]=='1'))
    { // bath room control
        scene_nr = SCENE_MENU_SUBMENU_BATH;
        RCChangeScene();
        return;
    }
    if ( (strcmp(parameter_name,"rmt_button2_a2_data_1")==0) && (parameter_value[0]=='1'))
    { // Kitchen control
        scene_nr = SCENE_MENU_SUBMENU_KITCHEN;
        RCChangeScene();
        return;
    }
    if ( (strcmp(parameter_name,"rmt_button2_a2_data_2")==0) && (parameter_value[0]=='1'))
    { // Garage control
        scene_nr = SCENE_MENU_SUBMENU_GARAGE;
        RCChangeScene();
        return;
    }
    
    // back to main menu
    if ( (strcmp(parameter_name,"rmt_button3_z2_data_1")==0) && (parameter_value[0]=='1'))
    { // bath room control
        scene_nr = SCENE_MENU_SUBMENU;
        RCChangeScene();
        return;
    }
    
    
    //--------------------------------------------------------------------------
    // Newsticker
    if ( (strcmp(parameter_name,"rmt_text1_f2_data")==0) && (parameter_value[0]=='1'))
    { // messages
        sprintf(str, "rmt_text1_f2_cfg ; This is message no. %d .... This is message no. %d ... This is message no. %d ...;1",
                ticker_cnt, ticker_cnt+1, ticker_cnt+2);
        SendStringToStream(sock, str);
        ticker_cnt+=3;
        return;
    }
    if ( (strcmp(parameter_name,"rmt_text1_f3_data")==0) && (parameter_value[0]=='1'))
    { // messages
        sprintf(str, "rmt_text1_f3_cfg ; Company A USD %3d.00 (+3), Company B USD %3d.00 (+3), Company C USD %3d.00 (+3) ...;2",
                100+ticker_cnt, 200+ticker_cnt+1, 300+ticker_cnt+2);
        SendStringToStream(sock, str);
        ticker_cnt+=3;
        return;
    }
    
    //--------------------------------------------------------------------------
    // Audio
    if ( (strcmp(parameter_name,"rmt_audio1_h2_data")==0) && (parameter_value[0]=='1'))
    { // messages
        strcpy(str, "rmt_audio1_h2_cfg ;Title: audio_02.m4a (loaded);http://www.synertronixx.de/audio/audio_02.m4a; 1");
        SendStringToStream(sock, str);
        return;
    }
    
    //--------------------------------------------------------------------------
    // digital graph values
    if ( (strcmp(parameter_name,"rmt_switch3_a1_data_1")==0) )
    { // messages
        if(parameter_value[0]=='1')
            digital_color_on[0] = 1;
        else
            digital_color_on[0] = 0;
        return;
    }
    if ( (strcmp(parameter_name,"rmt_switch3_a1_data_2")==0) )
    { // messages
        if(parameter_value[0]=='1')
            digital_color_on[1] = 1;
        else
            digital_color_on[1] = 0;
        return;
    }
    if ( (strcmp(parameter_name,"rmt_switch3_a1_data_3")==0) )
    { // messages
        if(parameter_value[0]=='1')
            digital_color_on[2] = 1;
        else
            digital_color_on[2] = 0;
        return;
    }
    
    if ( (strcmp(parameter_name,"rmt_switch3_a2_data_1")==0) )
    { // messages
        if(parameter_value[0]=='1')
            digital_color_on[3] = 1;
        else
            digital_color_on[3] = 0;
        return;
    }
    if ( (strcmp(parameter_name,"rmt_switch3_a2_data_2")==0) )
    { // messages
        if(parameter_value[0]=='1')
            digital_color_on[4] = 1;
        else
            digital_color_on[4] = 0;
        return;
    }
    if ( (strcmp(parameter_name,"rmt_switch3_a2_data_3")==0) )
    { // messages
        if(parameter_value[0]=='1')
            digital_color_on[5] = 1;
        else
            digital_color_on[5] = 0;
        return;
    }
    if ( (strcmp(parameter_name,"rmt_switch3_a3_data_1")==0) )
    { // messages
        if(parameter_value[0]=='1')
            digital_color_on[6] = 1;
        else
            digital_color_on[6] = 0;
        return;
    }
    if ( (strcmp(parameter_name,"rmt_switch3_a3_data_3")==0) )
    { // messages
        if(parameter_value[0]=='1')
            digital_color_on[7] = 1;
        else
            digital_color_on[7] = 0;
        return;
    }
    
    if ( (strcmp(parameter_name,"rmt_radio1_b1_data")==0) )
    { // messages
        switch ( parameter_value[0] )
        {
            case '0': freq_scale = 0.1; break;
            case '1': freq_scale = 0.2; break;
            case '2': freq_scale = 0.5; break;
            case '3': freq_scale = 1.0; break;
            case '4': freq_scale = 2.0; break;
                
            default: freq_scale = 1.0; 
                break;
        }
        return;
    }
    
    
    
    //--------------------------------------------------------------------------
    // Bar graph vertical
    if ( (strcmp(parameter_name,"rmt_switch1_b4_data")==0) )
    { // messages
        if(parameter_value[0]=='1')
        {
            bar_filled = 1;
            SendStringToStream(sock, "rmt_graph1_b4_cfg ;Pseudo bar graph example with filled bars:;8;220; 35; %.1f; -5.; 85.0; 9");
            SendStringToStream(sock, "rmt_switch1_b4_cfg ;Draw filled bars:; 1");
        }
        else
        {
            bar_filled = 0;
            SendStringToStream(sock, "rmt_graph1_b4_cfg ;Pseudo bar graph example without filled bars:;8;220; 35; %.1f; -5.; 85.0; 9");
            SendStringToStream(sock, "rmt_switch1_b4_cfg ;Draw filled bars:; 0");
        }
        counter_test = 5;
        return;
    }
        
    //--------------------------------------------------------------------------
    if(parameter_value[0]=='1')
    {
        // Main menu iPhone
        if (strcmp(parameter_name,"rmt_button1_a1_data")==0)
        { // RC All control elements
            scene_nr = SCENE_OVERVIEW;
            RCChangeScene();
            return;
        }
        if ((strcmp(parameter_name,"rmt_button1_a2_data")==0) ||
            (strcmp(parameter_name,"rmt_button2_p0_data_1")==0))
        { // RC mixed control elements
            scene_nr = SCEND_MIXED;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_a3_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p0_data_2")==0) )
        { // RC some control elements with update
            scene_nr = SCENE_MIXED_UPDATE;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_a4_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p1_data_1")==0)  )
        { // RC Button with 'Sub'-RCs
            scene_nr = SCENE_MENU_SUBMENU;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_a5_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p1_data_2")==0)  )
        { // RC Newsticker
            scene_nr =SCENE_NEWSTICKER;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_a6_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p2_data_1")==0)  )
        { // RC Analog Graph with data generator
            scene_nr = RCGetAnaloGraphScene();
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_a7_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p2_data_2")==0)  )
        { // RC Digital Graph with data generator
            scene_nr = SCENE_GRAPH_DIGITAL;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_a8_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p3_data_1")==0)  )
        { // RC Bar graph
            scene_nr =SCENE_GRAPH_PSEUDO_BAR_VERTICAL;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_a9_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p3_data_2")==0)  )
        { // bar graph horizontal
            scene_nr = SCENE_GRAPH_PSEUDO_BAR_HORIZONTAL;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_b0_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p4_data_1")==0)  )
        { // slider controlled graph
            scene_nr = SCENE_GRAPH_SLIDER_CONTROLLED;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_b1_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p4_data_2")==0)  )
        { // RC Audio
            scene_nr = SCENE_AUDIO;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_b2_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p5_data_1")==0)  )
        { // draw element (basics)
            scene_nr = SCENE_DRAW_BASICS;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_b3_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p5_data_2")==0)  )
        { // Bargraph and pie chart (Draw element)
            scene_nr = RCGetChartScene(); 
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_b4_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p6_data_1")==0)  )
        { // Curves (Draw element)
            scene_nr = SCENE_DRAW_CURVES;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_b5_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p7_data_1")==0)  )
        { // Map interactive
            scene_nr = SCENE_MAP_INTERACTION;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_b6_data")==0)||
            (strcmp(parameter_name,"rmt_button2_p7_data_2")==0)  )
        { // Map: Hannover photo show
            scene_nr = SCENE_MAP_PICTURES;
            RCChangeScene();
            return;
        }
        if ( (strcmp(parameter_name,"rmt_button1_z1_data")==0)  )
        { // main menu
            scene_nr = RCGetMainScene();
            RCChangeScene();
            return;
        }
        
    }
    
    
    
    
    //--------------------------------------------------------------------------
    // RC slider controlled graph
    if (strcmp(parameter_name,"rmt_slider1_b5_data")==0) 
    { // main menu
        sprintf(str,"rmt_graph1_b5_data ;%s", parameter_value);
        SendStringToStream(sock, str);
        return;
    }
    
    
    //--------------------------------------------------------------------------
    // Map interactive
    if (strcmp(parameter_name,"rmt_map1_a1_data")==0) 
    { // main menu
        sscanf(buffer, "rmt_map1_a1_data %f %f %f %f", &latitude, &longitude,  &delta_latitude, &delta_longitude);
        
        // update texts
        sprintf(str,"rmt_text1_a1_cfg ;Latitude: %.5f deg. (H: %.0f m);0", latitude , delta_latitude );
        SendStringToStream(sock, str);
        sprintf(str,"rmt_text1_a2_cfg ;Longitude: %.5f deg. (W: %.0f m);0",longitude , delta_longitude);
        SendStringToStream(sock, str);
        
        map_count++;
        if(map_count > 50)
        {  // remove all pins
            sprintf(str,"rmt_map1_a1_cfg ;Move/zoom map to get new pins:; 200; %.5f; %.5f;%.1f ; 0;1", latitude, longitude, delta_latitude);
            SendStringToStream(sock, str);
            map_count=0;
        }
        
        // set new pin
        sprintf(str,"rmt_map1_a1_data ;%.5f;%.5f;Position %d of 50:;Latitude: %.5f Longitude: %.5f;", latitude, longitude, map_count, latitude, longitude);
        SendStringToStream(sock, str);
        
        return;
    }
    
    
    // get the actual config again
    if ( strcmp(parameter_name,"get_config")==0)
    { //
      scene_nr = RCGetMainScene();
      RCChangeScene();
      return;
    }
    
    /*  // Add more commands to process here
     else
     if ( strcmp(parameter_name,"???")==0)
     { //
     RCChangeScene();
     }
     
     */

}

/******************************************************************************
 Function:     RCGetMainScene
 Description:  get main menu depending om hardware and orientation
 Parameter:    none
 Return:       none
 Date:         11.11.2012
 Changes:
 ******************************************************************************/
int
RCGetMainScene(void)
{
   int ret_value = SCENE_MAIN_IPHONE;
  
    if ( (display_mode == DISPLAY_IPAD_LANDSCAPE) || (display_mode == DISPLAY_IPAD_PORTRAIT))
    {
        ret_value = SCENE_MAIN_IPAD;
    }


    return ret_value;
}


/******************************************************************************
 Function:     RCGetAnaloGraphScene
 Description:  get analog graph scene no. depending om hardware and orientation
 Parameter:    none
 Return:       none
 Date:         11.11.2012
 Changes:
 ******************************************************************************/
int
RCGetAnaloGraphScene(void)
{
    int ret_value = SCENE_GRAPH_ANALOG_IPHONE;
    
    if ( (display_mode == DISPLAY_IPAD_LANDSCAPE) || (display_mode == DISPLAY_IPAD_PORTRAIT))
    {
        ret_value = SCENE_GRAPH_ANALOG_IPAD;
    }
    return ret_value;
}

/******************************************************************************
 Function:     RCGetChartScene
 Description:  get pie chart scene no. depending om hardware and orientation
 Parameter:    none
 Return:       none
 Date:         13.11.2012
 Changes:
 ******************************************************************************/
int
RCGetChartScene(void)
{
    int ret_value = SCENE_DRAW_BARGRAPH_PIECHART_IPHONE;
    
    if ( (display_mode == DISPLAY_IPAD_LANDSCAPE) || (display_mode == DISPLAY_IPAD_PORTRAIT))
    {
        ret_value = SCENE_DRAW_BARGRAPH_PIECHART_IPAD;
    }
    return ret_value;
}



/******************************************************************************
 Function:     RCNextStep
 Description:  send commands to DeviLAN app
 Parameter:    sock: ptr to buffer with socket descriptor
 Return:       none
 Date:         16.11.2012
 Changes:
 ******************************************************************************/
void
RCNextStep(int* sock)
{
    char str[300];
    char str2[20];
    unsigned char byte;
    int animate=1;
    float digi_value[8];
    int k;
    
    timertime = timertime_remote_test;
    
    // first insert the control elements
    if (counter_test < TEST_DATA_SIZE)
    {
        if (test_data[scene_nr][counter_test] != NULL)
        {  // insert elements
            SendStringToStream(sock, test_data[scene_nr][counter_test]);
            timertime = timertime_remote_test/4;
            animate = 0;
        }
    }

    
    // when all elements inserted send data to them depending on the selected scene
    if (animate)
    {
        // Mixed elements animated
        if (scene_nr == SCENE_MIXED_UPDATE)
        {
            sprintf(str, "rmt_header1_05_cfg ;Mixed examples %d", counter_test);
            SendStringToStream(sock, str);
            
            sprintf(str,"rmt_slider1_AA_cfg ;Temperature bathroom %d°C; 5; 35; %d;%%5.1f°C;1.0", counter_test&0x1F-5, counter_test&0x1F);
            SendStringToStream(sock, str);
            
            sprintf(str,"rmt_progress1_AA_cfg ;Frequency:; 5; 35; %d; %%5.2fHz; 0.5",
                    counter_test&0x1F);
            SendStringToStream(sock, str);
            
            if (counter_test&0x01)
                strcpy(str2, "On:");
            else
                strcpy(str2, "Off:");
            
            sprintf(str,"rmt_switch1_10_cfg ;Light intern %s; %d", str2,  counter_test&0x01);
            SendStringToStream(sock, str);
            
            sprintf(str,"rmt_button3_10_cfg ;Start;Stop %d;Pause", counter_test);
            SendStringToStream(sock, str);
            
            sprintf(str,"rmt_edit1_11_cfg ;Enter text here:;Text to send %d", counter_test);
            SendStringToStream(sock, str);
        }
        
        if ( (scene_nr == SCENE_OVERVIEW)  && (counter_test<200))
        {  // All elements
            sprintf(str,"rmt_graph1_aa_cfg ;Description text for graph (Just a counter: %d):;4;170; 50; %%.1f; -3.5; 3.5; 7", counter_test);;
            SendStringToStream(sock, str);
            
            sprintf(str,"rmt_graph1_aa_data ;%5.2f;%5.2f;%5.2f;%5.2f;%5.2f",
                    sin(graphTestCnt),
                    cos(graphTestCnt),
                    tan(graphTestCnt),
                    4 * sin(graphTestCnt)  * cos(graphTestCnt/10),
                    -2 + 0.5*sin(graphTestCnt*3));
            SendStringToStream(sock, str);
            graphTestCnt +=0.1;
        }
        
        
        if ((scene_nr == SCENE_GRAPH_ANALOG_IPHONE) ||(scene_nr == SCENE_GRAPH_ANALOG_IPAD))
        {  // Graph
            sprintf(str,"rmt_graph1_b1_data ;%5.2f;%5.2f;%5.2f;%5.2f;%5.2f",
                    sin(graphTestCnt),
                    cos(graphTestCnt),
                    tan(graphTestCnt),
                    4 * sin(graphTestCnt)  * cos(graphTestCnt/10),
                    -2 + 0.5*sin(graphTestCnt*3));
            SendStringToStream(sock, str);
            graphTestCnt += (0.1*freq_scale);
            
            float value = 20;
            if (sin(graphTestCnt2*2)<0)
                value = -10;
            
            sprintf(str,"rmt_graph1_b2_data ;%5.2f;%5.2f;%5.2f;%5.2f",
                    30 + 10*sin(graphTestCnt2/2),
                    -20 + 10*cos(graphTestCnt2),
                    50 + 10*sin(graphTestCnt)  * cos(graphTestCnt/10),
                    value);
            SendStringToStream(sock, str);
            SendStringToStream(sock, str);
            str[12]='3';
            SendStringToStream(sock, str);
            SendStringToStream(sock, str);

            graphTestCnt2 += (0.2*freq_scale);
        }
        
        if (scene_nr == SCENE_GRAPH_DIGITAL)
        {  // digitalGraph
            byte = (unsigned char)(counter_test>>3);
            for (k=0; k<8; k++)
            {
                if (byte & (0x01<<k))
                    digi_value[k] = k + (0.8 * digital_color_on[k]);
                else
                    digi_value[k] = k;
            }
            sprintf(str,"rmt_graph1_b3_data ;%5.2f;%5.2f;%5.2f;%5.2f;%5.2f;%5.2f;%5.2f;%5.2f",
                    digi_value[0], digi_value[1],digi_value[2],digi_value[3],
                    digi_value[4],digi_value[5],digi_value[6],digi_value[7]);
            SendStringToStream(sock, str);
        }
        
        if (scene_nr == SCENE_GRAPH_PSEUDO_BAR_VERTICAL)
        {  // Bar graph
            if (counter_test<272)
            {
                for (k=0; k<8; k++)
                {
                    if (  (counter_test > (k*32+5)) &&  (counter_test< (k+1)*32 -5) )
                    {
                        if (bar_filled)
                            digi_value[k] = (k+1) * 10 * (counter_test&0x01);
                        else
                            digi_value[k] = (k+1) * 10;
                    } else
                        digi_value[k] = 0;
                }
                sprintf(str,"rmt_graph1_b4_data ;%.0f;%.0f;%.0f;%.0f;%.0f;%.0f;%.0f;%.0f",
                        digi_value[0], digi_value[1],digi_value[2],digi_value[3],
                        digi_value[4],digi_value[5],digi_value[6],digi_value[7]);
                SendStringToStream(sock, str);
            }
        }
        
        
        if (scene_nr == SCENE_GRAPH_PSEUDO_BAR_HORIZONTAL)
        {  // Pseudo bar graph  vertical
            
            if (counter_test<272)
            {
                
                for (k=0; k<8; k++)
                {
                    if ( counter_test > (k*32) )
                    {
                        digi_value[k] = (k+1) * 10 -3 + (6 * (counter_test&0x01));
                    } else
                        digi_value[k] = (k+1) * 10;
                }
                sprintf(str,"rmt_graph1_b5_data ;%.0f;%.0f;%.0f;%.0f;%.0f;%.0f;%.0f;%.0f",
                        digi_value[0], digi_value[1],digi_value[2],digi_value[3],
                        digi_value[4],digi_value[5],digi_value[6],digi_value[7]);
                SendStringToStream(sock, str);
            }
        }
        
        if (scene_nr == SCENE_DRAW_BARGRAPH_PIECHART_IPHONE)
        { // bar graph and pie chart
           RCDrawDemoChart(sock, 1);
        }
        if (scene_nr == SCENE_DRAW_BARGRAPH_PIECHART_IPAD)
        { // bar graph and pie chart
            RCDrawDemoChart(sock, 2);
        }
        
        if (scene_nr == SCENE_DRAW_CURVES)
        {  // curves
            RCDrawDemoCurves(sock);
        }
    }
    
    
    counter_test++;
}



/******************************************************************************
 Function:     RCDrawDemoChart
 Description:  draw a bar graph and a pie chart
 Parameter:    sock: ptr to socket descriptor
 Return:       none
 Date:         13.11.2012
 Changes:      
 ******************************************************************************/
void
RCDrawDemoChart(int* sock, float scale)
{   
#define MAX_BARS 4
#define TWOPI 6.283185 //30717959
    
    char str[200];
    float values[MAX_BARS];
    float sum = 0;
    int i;
    int fillMode;
    float zero_line =  180 *scale;
    float startAngle=0;
    float stopAngle=0;
    float rx, ry;
    
    for(i=0; i<MAX_BARS; i++)
    {
        values[i] = 15 + (random()/ (2147483648/2)) *100 + i*10;
        sum += values[i];
    }
    
    fillMode = bargraphCnt&0x03;
    
    //update header
    sprintf(str, "rmt_draw1_a1_cfg ;Description for draw element (update %d):;200",bargraphCnt);
    SendStringToStream(sock, str);

    // clear
    SendStringToStream(sock,"rmt_draw1_a1_data ;d");
    SendStringToStream(sock,"rmt_draw1_a1_data ;n");
    
    // clear background
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;1;0;1;1");
    sprintf(str, "rmt_draw1_a1_data ;r;0;0;%d;%.0f;1", display_width, 200*scale);
    SendStringToStream(sock,str);
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;0.7;0.7;0.7;1");
    sprintf(str, "rmt_draw1_a1_data ;r;3;3;%d;%.0f;1", display_width-6, 200*scale-6);
    SendStringToStream(sock,str);

    
    // lines
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;0;0;0;1");
    float width = display_width * 0.6;
    
    for(i=0; i<5; i++)
    {
        sprintf(str, "rmt_draw1_a1_data ;l;10;%.0f;%.0f;%.0f", zero_line - i*30*scale, width, zero_line - i*30*scale);
        SendStringToStream(sock,str);
    }
    
    
    
    // bars & cricles 
    rx = display_width * 0.8;
    ry = 40;
    
    
    // shadow for pie chart
    sprintf(str, "rmt_draw1_a1_data ;a;%.0f;%.0f;%.0f;0.0;6.3;0;1", rx+4, ry + 40*scale +4, 40*scale);
    SendStringToStream(sock, str);

    for(i=0; i<4;i++)
    {
     
        SendStringToStream(sock,"rmt_draw1_a1_data ;c;0.3;0.3;0.3;0.8");
        
        // Bar
        sprintf(str, "rmt_draw1_a1_data ;r;%.0f;%.0f;%.0f;%.0f;1", 24+i*50*scale, zero_line-values[i]*scale+4, 30*scale, values[i]*scale);
        SendStringToStream(sock, str);
        
        // Color
        switch(i)
        {
            case 0: SendStringToStream(sock,"rmt_draw1_a1_data ;c;1;0;0;0.8"); break;
            case 1: SendStringToStream(sock,"rmt_draw1_a1_data ;c;0;1;0;0.8"); break;
            case 2: SendStringToStream(sock,"rmt_draw1_a1_data ;c;0;0;1;0.8"); break;
            case 3: SendStringToStream(sock,"rmt_draw1_a1_data ;c;0;1;1;0.8"); break;
        }
        
        // Rect
        sprintf(str, "rmt_draw1_a1_data ;r;%.0f;%.0f;%.0f;%.0f;1", 20+i*50*scale, zero_line-values[i]*scale,  30*scale, values[i]*scale);
        SendStringToStream(sock, str);
        
        // % Text
        sprintf(str, "rmt_draw1_a1_data ;t;%.0f;10;%.0f;c;%.0f", 35 + i*50*scale, (float)20, values[i]);
        SendStringToStream(sock, str);
        
        // Circle
        stopAngle += (values[i]/sum)*TWOPI;
        sprintf(str, "rmt_draw1_a1_data ;a;%.0f;%.0f;%.0f;%0.3f;%.3f;0;1", rx, ry + 40*scale, 40*scale, startAngle, stopAngle);
        SendStringToStream(sock, str);
        
        // Arc
        sprintf(str, "rmt_draw1_a1_data ;a;%.0f;%.0f;%.0f;%0.3f;%.3f;0;%d", rx, ry + 120*scale, 30*scale, startAngle, stopAngle -0.1, fillMode);
        SendStringToStream(sock, str);
        
        startAngle = stopAngle;
    }
    

    // Point in the middle
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;0.3;0.3;0.3;1");
    sprintf(str, "rmt_draw1_a1_data ;a;%.0f;%.0f;5;0.0;6.3;0;1", rx, ry + 40*scale);
    SendStringToStream(sock, str);

    // some ellipses
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;1;1;0;0.3");
    
    for(i=0; i<4;i++)
    {
        sprintf(str, "rmt_draw1_a1_data ;e;%.0f;25;35;10;1", (float)(20+i*50*scale) );
        SendStringToStream(sock, str);
    }

    // ellipse for sum
    sprintf(str, "rmt_draw1_a1_data ;e;%.0f;25;35;10;1", rx-17);
    SendStringToStream(sock, str);
    
    // sum text
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;1;1;1;1");
    sprintf(str, "rmt_draw1_a1_data ;t;%.0f;10;20;c;%.0f;1", rx, sum);
    SendStringToStream(sock, str);
    
    
    // percent texts in bar
    for(i=0; i<4;i++)
    {
        sprintf(str, "rmt_draw1_a1_data ;t;%.0f;%.0f;%.0f;c;%.1f%%", (float)(20 + 15*scale+i*50*scale),zero_line-15*scale, 10*scale, (values[i]/sum)*100);
        SendStringToStream(sock, str);
    }
        
    
    bargraphCnt++;
    
}

/******************************************************************************
 Function:     RCDrawDemoCurves
 Description:  draw curve graph
 Parameter:    sock: ptr to socket descriptor
 Return:       none
 Date:         11.11.2012
 Changes:      
 ******************************************************************************/
void
RCDrawDemoCurves(int* sock)
{   
    char str[200];
    int i;
    int y, y_old;
    
    
    // Update header text
    sprintf(str, "rmt_draw1_a1_cfg ;Description for draw element (update %d):;200",bargraphCnt);
    SendStringToStream(sock, str);

    // clear
    SendStringToStream(sock,"rmt_draw1_a1_data ;d");
    SendStringToStream(sock,"rmt_draw1_a1_data ;n");
    
    // clear background
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;1;0;1;1");
    sprintf(str, "rmt_draw1_a1_data ;r;0;0;%d;200;1", display_width);
    SendStringToStream(sock,str);
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;0.7;0.7;0.7;1");
    sprintf(str, "rmt_draw1_a1_data ;r;3;3;%d;194;1", display_width-6);
    SendStringToStream(sock,str);
    
    // lines
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;0;0;0;1");
    sprintf(str, "rmt_draw1_a1_data ;l;10;180;%d;180", display_width-10);
    //SendStringToStream(sock,"rmt_draw1_a1_data ;l;10;180;300;180");
    SendStringToStream(sock,str);
    
    // texts
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;1;1;1;1");
    for(i=0; i < (display_width-20); i+=20)
    {
        sprintf(str, "rmt_draw1_a1_data ;t;%d;182;10;c;%d", 10+i, i);    // x values
        SendStringToStream(sock, str);
    }
    for(i=20; i<200; i+=20)
    {
        sprintf(str, "rmt_draw1_a1_data ;t;%d; %d;10;c;%d", display_width/2, 180-i, i);  // y values
        SendStringToStream(sock, str);
    }

   
    // curve 1
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;1;0;0;0.8");
    y_old = 30;
    for(i=0; (i+2)< (display_width/5); i++)
    {
        y = 30 + (random()&0x0F) *5;
        sprintf(str, "rmt_draw1_a1_data ;l;%d;%d;%d; %d", 10 + (i * 5), y_old, 10 + (i+1)*5, y);
        SendStringToStream(sock, str);
        y_old = y;
    }
    
    // curve 2
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;0;1;0;0.8");
    y_old = 80;
    for(i=0; (i+2)<(display_width/5); i++)
    {
        y = 80 + (random()&0x0F) *5;
        sprintf(str, "rmt_draw1_a1_data ;l;%d;%d;%d; %d", 10 + (i * 5), y_old, 10 + (i+1)*5, y);
        SendStringToStream(sock, str);
        y_old = y;
    }

    // curve 3
    SendStringToStream(sock,"rmt_draw1_a1_data ;c;0;0;1;0.8");
    y_old = 120;
    for(i=0; (i+2)<(display_width/10); i++)
    {
        y = 120 + (random()&0x0F) *3;
        sprintf(str, "rmt_draw1_a1_data ;l;%d;%d;%d; %d", 10 + (i * 10), y_old, 10 + (i+1)*10, y);
        SendStringToStream(sock, str);
        y_old = y;
    }

    SendStringToStream(sock,"rmt_draw1_a1_data ;u");
    
    bargraphCnt++;
    
}


/******************************************************************************
 Function:     RCChangeScene
 Description:  change settings for new scene
 Parameter:    none
 Return:       none
 Date:         13.11.2012
 Changes:
 ******************************************************************************/
void
RCChangeScene(void)
{
    int i;
    
    if( (scene_nr >= 0) && (scene_nr < TEST_DATA_SCENE))
    {
        printf("%s: RC selected scene %d\n", appl_name, scene_nr);
        counter_test = 0;
      
        if(// (scene_nr == SCENE_MAIN) ||
           (scene_nr == SCENE_OVERVIEW) ||
           (scene_nr == SCENE_GRAPH_ANALOG_IPHONE) ||
           (scene_nr == SCENE_GRAPH_ANALOG_IPAD) ||
           (scene_nr == SCENE_GRAPH_DIGITAL) )
            timertime_remote_test = 50;
        else
            timertime_remote_test = 500;
        
        if( (scene_nr == SCENE_MAIN_IPAD) || (scene_nr == SCENE_MAIN_IPHONE))
            timertime_remote_test = 25;

        
        if((scene_nr == SCENE_GRAPH_PSEUDO_BAR_VERTICAL) ||
           (scene_nr == SCENE_GRAPH_PSEUDO_BAR_HORIZONTAL) )
        {
            timertime_remote_test = 10;
            bar_filled    = 1;
        }
        
        if(scene_nr == SCENE_GRAPH_DIGITAL)
        { // digital
            for(i=0; i<8; i++)
                digital_color_on[i]=1;
        }
        
        if( (scene_nr == SCENE_DRAW_BARGRAPH_PIECHART_IPHONE) || (scene_nr == SCENE_DRAW_BARGRAPH_PIECHART_IPAD))
        { // bargraph + pie chart
            timertime_remote_test = 3000;
        }

        if(scene_nr == SCENE_DRAW_CURVES)
        { // curves graph
            timertime_remote_test = 2000;
        }

        timertime = timertime_remote_test;
    }
}


// End of pure C-Function part


/******************************************************************************
Function:     SendStringToStream
Description:  send a string to TCP/IP socket
Parameter:    sock: ptr to socket desciptor
              str:  string to send
Return:       nr of bytes send to socket
Date:         28.09.2012
Changes:
******************************************************************************/
int
SendStringToStream(int* sock, char* str)
{
  int ret_value=0;
  char buffer[500];

  strcpy(buffer, str);
  strcat(buffer, "\r");

  if(*sock != -1)
  {
    ret_value = ServerSendMsg(sock, buffer);

    // debug output
    if(debug_traffic)
      printf("%s: S: %s\n", appl_name, str);
  }

  return ret_value;
}

// end of file
