/*******************************************************************************
*  (c) 2002, synertronixx GmbH
*  Vahrenwalder Str. 7
*  D-30165 Hannover
*  Tel. : 0511 / 93 57 670
*  Fax. : 0511 / 93 57 679
*  Web  : www.synertronixx.de
*  eMail: info@synertronixx.de
* ----------------------------
* Name          : dio_test.c
* Version       : 1.06
* Datum         : 19.02.2003
* Autor         : Blaschke
* Beschreibung  : DeviLAN C-Treiber
*                 Beispielprogramm fuer die Verwendung der Treiberroutinen
*                 fuer die digitalen Ein- und Ausgaenge
*******************************************************************************/

//Dos-Header
#include <DOS.H>
#include <STDIO.H>
#include <STRING.H>
#include <STDLIB.H>

// DeviLAN-Header
#include "../devilan_106/port.h"
#include "../devilan_106/intrhndl.h"


/*******************************************************************************
* H A U P T P R O G R A M M
*******************************************************************************/

int main()
{
   unsigned char porta;
   unsigned char portb=0x00;
   unsigned char portc;
   unsigned char portc2;
   unsigned char portd;

   printf("Starte Testprogramm fuer digitale Ein- und Ausgaenge\n\r");

   DeviLANInit();  // Allgemeine DeviLAN Initialisierungsfunktion
                   // muss zu Beginn des Programms einmal aufgerufen werden

   Port8255Init(); // Portzugriff initialisieren
                   // Port8255Init() muss zu Beginn des Programms einmal aufgerufen werden
                   
   printf("Initialisierung abgeschlossen ...\n\r");

   // Konfiguration der Ports A und C
   PortConfiguration(PORTA_INPORT);   // Port A (8 Bit) als Eingang konfigurieren
   PortConfiguration(PORTC1_OUTPORT); // Port C1 (4 Bit) als Ausgang konfigurieren
   PortConfiguration(PORTC2_INPORT);  // Port C2 (4 Bit) als Eingang konfigurieren
   // Anmerkung: Port B ist immer Ausgangsport (Open Kollektor)
   //            Port D ist immer Eingangsport

   printf("Ports konfiguriert\n\r");

   //Hauptschleife
   do
   {
      // Eingangsports lesen
      porta=PortAByteIn();
      portc=PortCByteIn();
      portc2=((portc&0xF0)>>4); // Port C2 sind die Bits 5..7 von Port C
      portd=PortDByteIn();

      // Daten der Eingangsports ausgeben
      printf("PortA : %02X\n\r", porta);
      printf("PortC2: %2X\n\r",  portc2);
      printf("PortD : %02X\n\r", portd);

      // Ausgaenge setzen
      PortBByteOut(portb);
      portb++;

      // Einzelzugriff auf Port C1 (Bit 0-3 von Port C)
      PortCBitOut(0, HIGH);
      PortCBitOut(1, LOW);
      PortCBitOut(2, HIGH);
      PortCBitOut(3, LOW);

      // Bytezugriff auf Port C
      PortCByteOut(0x0A); // Hat dieselbe Funktion wie die 4 Einzelbefehle
                          // Die oberen vier Bit werden ignoriert, da Port C1
                          // als Eingang konfiguriert ist

   }
   while(portb!=0x00);

   // Programm beenden

   PortBByteOut(0x00);               // Alle Bits von Port B auf Low
   PortConfiguration(PORTC1_INPORT); // Port C1 (4 Bit) wieder als Eingang konfigurieren

   printf("\n\rTestprogramm beendet\n\r");

   return 0;
}



