/*******************************************************************************
*  (c) 2002, synertronixx GmbH
*  Vahrenwalder Str. 7
*  D-30165 Hannover
*  Tel. : 0511 / 93 57 670
*  Fax. : 0511 / 93 57 679
*  Web  : www.synertronixx.de
*  eMail: info@synertronixx.de
* ----------------------------
* Name          : addatest.c
* Version       : 1.06
* Datum         : 19.02.2003
* Autor         : Blaschke
* Beschreibung  : DeviLAN C-Treiber
*                 Beispielprogramm fuer die Verwendung der Treiberroutinen
*                 fuer den Analog-Digital und Digital-Analog-Wandler
*                 Es werden jeweils N-Werte von den Kanaelen 0..3 und 4 (alle
*                 Kanaele kontinuierlich) abgetastet und ausgegeben
* Programmaufruf: addatest [Abtastrate]   z.B. addatest 125
* *****************************************************************************/

//Dos-Header
#include <DOS.H>
#include <STDIO.H>
#include <STRING.H>
#include <STDLIB.H>

// DeviLAN-Header
#include "../devilan_106/adc.h"
#include "../devilan_106/intrhndl.h"

// AD-Wert wird N mal ermittelt
#define N 20

/*******************************************************************************
* H A U P T P R O G R A M M
*******************************************************************************/

int main(int argc, char *argv[])
{
   int channel=0;            // Kanalnummer:     0..3, 4 alle Kanaele
   int baudrate=100;         // Baudrate:        3..1000Hz
   int gain=1;               // Vorverstaerkung: 1,2,4,8,16

   int n=0;                   // Zaehler
   int wdh;                   // Zaehler
   unsigned char adc_channel; // gelesene Kanalnummer
   long int      adc_value;   // gelesener AD-Wert in Mikrovolt
   
   printf("Starte Testprogramm fuer AD und DA-Wandler\n\r");
   if (argc==2)
     sscanf(argv[1],"%d",&baudrate);

   DeviLANInit();  // Allgemeine DeviLAN Initialisierungsfunktion
                   // muss zu Beginn des Programms einmal aufgerufen werden

   ADCInit();      // Kommunikation mit Analog-Digital-Wandler initialisieren
                   // Der DA-Wandler wird ueber die serielle Schnittstelle COM2
                   // des Beck SC12 angesteuert. COM 2 darf daher nicht fuer
                   // andere Aufgaben verwendet werden !!
                   // ADCInit() muss zu Beginn des Programms einmal aufgerufen werden
                   
   printf("Initialisierung abgeschlossen ...\n\r");

   // Ausgabe ueber DA-Wandler
   DACOut(1, 1000);     // Kanal 1 = 1000mV
   DACOut(2, 4095);     // Kanal 2 = 4095mV = Maximalwert

   // DA-Wandler einstellen und starten
   printf("\n\nNeue ADC-Einstellung: Baudrate %d, Kanal %1d, Verstaerkung %d\n\n", baudrate, channel, gain);
   if (ADCSet(baudrate, channel, gain) != ADC_NOERROR) // ADC einstellen und starten
   {
     printf("Parameterfehler bei Konfiguration des AD-Wandlers !!\n");
     printf("Programm wird abgebrochen !!\n");
     exit (0);
   }

   //Hauptschleife
   do
   {
     // Alle Werte aus dem ADC-Empfangspuffer auslesen
     // da sonst Datenueberlauf eintreten kann
     do
     {
       if (ADCRead(&adc_channel, &adc_value)==1)
       { // Wert gelesen
         n++;
         printf("%3d Kanal %1d  %9ld V\n\r", n, adc_channel, adc_value);
       }
     }
     while ( (ADCValidData() == 1) && (n<N));

     // Anmerkung:
     // Sollte die Abtastrate zu hoch sein, kommen die Daten schneller als sie
     // verarbeitet werden koennen, die Schleife wird dann ueber die Abfrage
     // ADCValidData() == 1 allein nicht beendet !
     // Entweder Daten vor Verarbeitung verwerfen oder Abtastrate verringern
     // bzw. wie hier Zaehlerabfrage verwenden

     if (n>=N)
     {// N Werte gewandelt -> neuen Kanal einstellen
       channel++;   // naechster Kanal
       if (channel<=4)
       {
         if (channel==4)
           baudrate*=4;
         n=0;       // Zaehler ruecksetzen
         printf("\n\nNeue ADC-Einstellung: Baudrate %d, Kanal %1d, Verstaerkung %d\n\n", baudrate, channel, gain);
         if (ADCSet(baudrate, channel, gain) != ADC_NOERROR) // ADC einstellen und starten
         {
           printf("Parameterfehler bei Konfiguration des AD-Wandlers !!\n");
           printf("Programm wird abgebrochen !!\n");
           exit (0);
         }
       }
     }
   }
   while(channel<=4);

   // Programm beenden

   // Ausgabe ueber DA-Wandler
   DACOut(1, 0);     // Kanal 1 = 0mV
   DACOut(2, 0);     // Kanal 2 = 0mV

   // ADC stoppen, ADCStopConvert() sollte zum Ende des
   // Programms einmal aufgerufen werden
   wdh=3;
   while ( (ADCStopConvert()!=ADC_NOERROR) && (wdh>=0))
   {
     wdh--;
     printf("ADC-Error: ADC_ACKNOWLEDGEERROR\n");
   }


   printf("\n\rTestprogramm beendet\n\r");

   return 0;
}



