#ifndef SERIAL_H
#define SERIAL_H

/*******************************************************************************
*  (c) 2002, synertronixx GmbH
*  Vahrenwalder Str. 7
*  30165 Hannover
*  Tel. : 0511 / 93 57 670
*  Fax. : 0511 / 93 57 679
*  Web  : www.synertronixx.de
*  eMail: info@synertronixx.de
* ----------------------------
* Projekt       : DeviLAN
* Name          : serial.h
* Version       : 1.04
* Datum         : 25.02.02
* Autor         : Borck, Blaschke
* *****************************************************************************/

typedef enum TLED             	  {LED1, LED2};
typedef enum TComPortDataBits      {db5BITS, db6BITS, db7BITS, db8BITS};
typedef enum TComPortStopBits      {sb1BITS, sb1HALFBITS, sb2BITS};
typedef enum TComPortParity        {ptNONE, ptODD, ptEVEN, ptMARK, ptSPACE};
typedef enum TComPortHandshaking   {hsNONE, hsRTSCTS, hsXONXOFF};

typedef struct _TSerialError
{
  unsigned long int RecvEvent;
  int					  ErrorCode;
}TSerialError;

#define SERIALERROR_NOERROR    		0x0000
#define SERIALERROR_OVERRUNERR 		0x0002
#define SERIALERROR_PARITYERR  		0x0004
#define SERIALERROR_FRAMEERR   		0x0008
#define SERIALERROR_BREAKERR   		0x0010
#define SERIALERROR_REVCBUFFERFULL  0x0040
#define SERIALERROR_TRMBUFFERFULL   0x0080

#define INITSERIAL_NO_ERROR         0x00
#define INITSERIAL_BAUDRATE_ERROR   0x01
#define INITSERIAL_HANDSHAKE_ERROR  0x02
#define INITSERIAL_DATABITS_ERROR   0x04
#define INITSERIAL_STOPBIT_ERROR    0x10
#define INITSERIAL_PARITY_ERROR     0x20


/* COM2 */

/* initalise internal serial interface */
unsigned char COM2Init(unsigned long int baudrate, int databits, int stopbits, int parity, int flowCtrl);

/* send serial data to internal serial interface */
unsigned int COM2TransmitBlock(char far* data_block, unsigned int length);

/* get data from internal serial interface */
unsigned int COM2ReadBlock(char far* data_block, unsigned int buffersize);

/* get internal serial error from buffer */
TSerialError COM2GetError(void);

/* restore old interrupt vector */
void COM2Release(void);

/* LED */

/* turn LED on */
void LEDOn(int LED);

/* turn LED off */
void LEDOff(int LED);

#endif

// End of file serial.h
