#ifndef CAN_H
#define CAN_H
/*******************************************************************************
*  (c) 2002, synertronixx GmbH
*  Vahrenwalder Str. 7
*  D-30165 Hannover
*  Tel. : 0511 / 93 57 670
*  Fax. : 0511 / 93 57 679
*  Web  : www.synertronixx.de
*  eMail: info@synertronixx.de
* ----------------------------
* Projekt       : DeviLAN
* Name          : can.h
* Version       : 1.04
* Datum         : 25.02.02
* Autor         : Borck, Blaschke
* *****************************************************************************/

/* bitrate CAN bus  */
/* baudrade code, register values BTR0/BTR1 */
#define CAN_BAUD_1M        0x0014  //   1 MBit / s
#define CAN_BAUD_500K      0x001C  // 500 kBit / s
#define CAN_BAUD_250K      0x011C  // 250 kBit / s
#define CAN_BAUD_125K      0x031C  // 125 kBit / s
#define CAN_BAUD_100K      0x432F  // 100 kBit / s
#define CAN_BAUD_50K       0x472F  //  50 kBit / s
#define CAN_BAUD_20K       0x532F  //  20 kBit / s
#define CAN_BAUD_10K       0x672F  //  10 kBit / s
#define CAN_BAUD_5K        0x7F7F  //   5 kBit / s

// error messages
#define CAN_ERR_OK                    0x00  // Kein Fehler
#define CAN_ERR_XMTFULL               0x01  /* Sendepuffer im Controller ist voll */
#define CAN_ERR_OVERRUN               0x02  /* CAN-Controller wurde zu spaet gelesen */
#define CAN_ERR_BUSERROR              0x04  /* Busfehler: ein Errorcounter erreichte Limit */
#define CAN_ERR_BUSOFF                0x08  /* Busfehler: CAN-Controller ging 'Bus-Off' */

#define CAN_ERR_RECEIVEBUF_OVERFLOW   0x10  /* Empfangsbuffer wurde nicht rechtzeitig ausgelesen */
                                            /* CAN-Meldungen gingen verloren */
                                            /* die aelteste(n) Meldung(en) wird(en) ueberschrieben */
#define CAN_ERR_TRANSMITBUF_OVERFLOW  0x20  /* Sendepuffer uebergelaufen, CAN-Meldung konnte nicht */
                                            /* in Sendepuffer geschrieben werden */
                                
// Initialisierungsfehlermeldungn
#define CAN_INIT_OK            0x00  /* Initialisierung erfolgreich*/
#define CAN_INIT_ERR_PARAMETER 0x01  /* Falscher Parameter bei Initialisierung */

typedef enum TCANMode    {CAN_STANDARD, CAN_EXTENDED};

typedef struct CANMsg
{
  unsigned long int ID;        /* 11/29 bit identifier              */
  unsigned char     RTR;       /* TRUE if REMOTE frame              */
  unsigned char     LEN;       /* Number of valid data bytes (0..8) */
  unsigned char     DATA[8];   /* Databytes                         */
}TCANMsg;


/* initialize CAN-Controller SJA1000 */
unsigned char CANInit(unsigned int baudrate, int mode,
                      unsigned long int acceptance_mask,
                      unsigned long int acceptance_code);

/* initialize CAN-Controller SJA1000 */
unsigned char  CANInitBTR(unsigned int btr1btr0, int mode,
                          unsigned long int acceptance_mask,
                          unsigned long int acceptance_code);

/* set CAN bus on	*/
void CANOn(void);

/* set CAN bus off */
void CANOff(void);


/* add data element in datastream */
unsigned char far CANSendData(TCANMsg msg);

/* add data from datastream */
TCANMsg CANGetData(void);

/* get number of messages in Receive-Buffer  */
unsigned int CANValidData(void);

/* get number of messages in Transmit-Buffer available */
int CANTransmitData(void);

/* get CAN-bus error status */
unsigned char CANGetStatus(void);

/* restore old interrupt vector for SJA1000 */
void CANRestoreOldInt(void);


#endif

// End of file can.h
